/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.zurrtum.create.client.catnip.levelWrappers.WrappedClientLevel;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11661;
import net.minecraft.class_11938;
import net.minecraft.class_11943;
import net.minecraft.class_12075;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PonderWorldParticles {
    private static final class_4604 FRUSTUM = new PassFrustum();
    private final class_11943 particleBatch = new class_11943();
    private final Map<class_3999, class_11938<?>> particles = Maps.newIdentityHashMap();
    private final Queue<class_703> newParticles = Queues.newArrayDeque();
    private final Object2IntOpenHashMap<class_5878> groupCounts = new Object2IntOpenHashMap();
    private final class_702 particleManager;
    PonderLevel world;
    private final Supplier<class_638> asClientWorld = Suppliers.memoize(() -> WrappedClientLevel.of(this.world));

    public PonderWorldParticles(PonderLevel world) {
        this.world = world;
        this.particleManager = class_310.method_1551().field_1713;
    }

    public void addParticle(class_703 particle) {
        Optional optional = particle.method_34019();
        if (optional.isPresent()) {
            if (this.canAdd((class_5878)optional.get())) {
                this.newParticles.add(particle);
                this.addTo((class_5878)optional.get(), 1);
            }
        } else {
            this.newParticles.add(particle);
        }
    }

    private boolean canAdd(class_5878 group) {
        return this.groupCounts.getInt((Object)group) < group.comp_4820();
    }

    protected void addTo(class_5878 group, int count) {
        this.groupCounts.addTo((Object)group, count);
    }

    public void tick() {
        this.particles.forEach((textureSheet, particlex) -> particlex.method_74287());
        if (!this.newParticles.isEmpty()) {
            class_703 particle;
            while ((particle = this.newParticles.poll()) != null) {
                this.particles.computeIfAbsent(particle.method_74274(), arg_0 -> ((class_702)this.particleManager).method_74281(arg_0)).method_74285(particle);
            }
        }
    }

    @Nullable
    public <T extends class_2394> class_703 addParticle(T parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        class_707 particleFactory = (class_707)this.particleManager.field_62618.method_74292().get(class_7923.field_41180.method_10206((Object)parameters.method_10295()));
        if (particleFactory == null) {
            return null;
        }
        class_703 particle = particleFactory.method_3090(parameters, this.asClientWorld.get(), x, y, z, velocityX, velocityY, velocityZ, this.world.field_9229);
        if (particle == null) {
            return null;
        }
        this.addParticle(particle);
        return particle;
    }

    public void renderParticles(class_11661 queue, class_4184 camera, class_12075 cameraRenderState, float tickProgress) {
        for (class_3999 particleTextureSheet : class_702.field_17820) {
            class_11938<?> particleRenderer = this.particles.get(particleTextureSheet);
            if (particleRenderer == null || particleRenderer.method_74284()) continue;
            this.particleBatch.method_74318(particleRenderer.method_74276(FRUSTUM, camera, tickProgress));
        }
        this.particleBatch.method_74319(queue, cameraRenderState);
    }

    public void resetParticles() {
        this.particleBatch.method_74317();
    }

    public void clearEffects() {
        this.newParticles.clear();
        this.groupCounts.clear();
    }

    @Environment(value=EnvType.CLIENT)
    public static class PassFrustum
    extends class_4604 {
        public PassFrustum() {
            super(new Matrix4f(), new Matrix4f());
        }

        public boolean method_74404(double x, double y, double z) {
            return true;
        }
    }
}

